/*
 * Projet Cryptolib CPS3 ASIP:
 *
 * Couche C JNI des traitements spcifiques du programme d'exemple
 *
*/
#include <jni.h>
#include "javautil.h"
#include <pkcs11.h>

/* Header for class fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation */

#ifndef _Included_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
#define _Included_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation

#undef fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_DEBUG
#define fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_DEBUG 1L
#undef fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_INFO
#define fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_INFO 2L
#undef fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_WARN
#define fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_WARN 3L
#undef fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_ERROR
#define fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_LOG_ERROR 4L

#define CK_ASSERT_OK 0L


/*****************/
/* Fonctions JNI */
/*****************/

/*
 * Implmentation de la mthode native qui permet de charger la librairie PKCS#11
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    connecte
 * Signature: (Ljava/lang/String;)V
 */
/* Fonction externalise dans system.h */

/*
* Implmentation de la mthode native ddie  l'initialisation de la librairie PKCS#11
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    initialiseLibrairie
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_initialiseLibrairie
(JNIEnv *, jobject);

/*
 * Implmentation de la mthode native ddie au traitement spcifique: Etat de connexion  la carte
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    etatConnexionCarte
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_etatConnexionCarte
  (JNIEnv *, jobject);

/*
 * Implmentation de la mthode native ddie au traitement spcifique: Assistant authentification
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    assistantAuthentification
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_assistantAuthentification
  (JNIEnv *, jobject);


/*
 * Implmentation de la mthode native ddie au traitement spcifique: Etat de saisie du code porteur
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    etatSaisieCodePorteur
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_etatSaisieCodePorteur
  (JNIEnv *, jobject);

/*
* Implmentation de la mthode native ddie au traitement spcifique: Recyclage du code porteur
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    recyclageCodePorteur
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_recyclageCodePorteur
  (JNIEnv *, jobject);

/*
 * Implmentation de la mthode native ddie au traitement spcifique: Assistant aprs retrait carte
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    authentificationApresRetraitCarte
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_authentificationApresRetraitCarte
  (JNIEnv *, jobject);

/*
* Implmentation de la mthode native ddie au traitement spcifique: Assistant aprs retrait lecteur
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    authentificationApresRetraitLecteur
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_authentificationApresRetraitLecteur
  (JNIEnv *, jobject);


/*
* Implmentation de la mthode native ddie au traitement spcifique: Lecture d'un objet de donnes applicatives (jeton)
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    lectureObjetDonneesApplicatives
 * Signature: ()[B
 */
JNIEXPORT jbyteArray JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_lectureObjetDonneesApplicatives
  (JNIEnv *, jobject);

/*
* Implmentation de la mthode native ddie au traitement spcifique: Modification d'un objet de donnes applicatives (jeton)
 * Class:     fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation
 * Method:    modificationObjetDonneesApplicatives
 * Signature: ()[B
 */
JNIEXPORT jbyteArray JNICALL Java_fr_asip_cps3_exemple_modele_jni_TraitementsSpecifiquesImplementation_modificationObjetDonneesApplicatives
  (JNIEnv *, jobject);


/*************************/
/* Fonctions utilitaires */
/*************************/


/*
 * Demande de connexion d'un lecteur
 */
int demandeConnecteLecteur(void);

/* 
 * Demande d'insertion d'une carte supporte
 */
int demandeIntroCarte(void);

/* 
 * Demande du choix du nombre d'essais possibles avant blocage du code porteur
 */
int demandeNbEssaisPossiblesAvantBlocageCodePorteur(void);

/*
 * Demande de saisie du code porteur
 */
int demandeCodePorteur(CK_FLAGS, CK_FLAGS, char**, unsigned char[16]);

/* 
 * Demande de recyclage du code porteur
 */
int demandeRecyclage(CK_FLAGS, CK_FLAGS, CK_FLAGS, char**, char**, char**, unsigned char[16]);

/* 
 * Demande d'action lecteur (retrait/connexion) ou carte (retrait/insertion)
 */
int demandeActionLecteurCarte(int, unsigned char[16]);

/* 
 * Alerte de carte retrouve
 */
void declencheAlerteCarteRetrouvee(void);

/* Demande de saisie de modification d'un objet */
int demandeModificationObjet(CK_BYTE_PTR, CK_ULONG, CK_BYTE_PTR *, CK_ULONG_PTR);

/* 
 * Rcupration du pointeur sur la liste des fonctions de la librairie PKCS#11
 */
CK_RV getPointeurFonctionsP11(void);

#endif
